<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Goal extends Model
{
    use HasFactory;

    protected $fillable = ['goal_name', 'status', 'date_added', 'date_updated']; // Fillable fields

    public function indicators()
    {
        return $this->hasMany(Indicator::class);
    }

    public function targets()
    {
        return $this->hasMany(Target::class);
    }

    public function indicatorDataEntries()
    {
        return $this->hasMany(IndicatorDataEntry::class);
    }
}
