<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class District extends Model
{
    use HasFactory;

    public $timestamps = false; // Disable timestamps

    protected $fillable = ['district_name', 'region', 'status', 'date_added', 'date_updated']; // Fillable fields

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function indicatorDataEntries()
    {
        return $this->hasMany(IndicatorDataEntry::class);
    }

    public function districtSdgIndex()
    {
        return $this->hasMany(DistrictSdgIndex::class);
    }

    public function user()
    {
        return $this->hasMany(User::class);
    }
}
