<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class UpperLevelRejectionMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $districtApprover;
    public $reason;
    public $indicatorDataEntry;
    public $level;
    public $url;
    public $disapprover;

    public function __construct($districtApprover, $indicatorDataEntry,$level, $reason, $disapprover)
    {
        $this->districtApprover = $districtApprover;
        $this->level = $level;
        $this->indicatorDataEntry = $indicatorDataEntry;
        $this->reason = $reason;
        $this->disapprover = $disapprover;
        $this->url = route('indicator_data_entries');
    }

    public function build()
    {
        return $this->subject('J&K - SDG: Data Entry Disapproval Notification')
                    ->markdown('emails.upper_level_rejection');
    }
}
