<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class RejectionNotificationMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;
    public $user, $level, $reason, $url;

    public function __construct($user, $level, $reason) {
        $this->user = $user;
        $this->level = $level;
        $this->reason = $reason;
        $this->url = route('indicator_data_entries');
    }

    public function build() {
        return $this->subject("Rejection at $this->level Level")
                    ->markdown('emails.rejection_notification');
    }
}

