<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class FinalApprovalNotificationMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;
    public $dataEntryUser, $user, $indicatorDataEntry, $dataEntryId, $url;

    public function __construct($dataEntryUser, $user, $indicatorDataEntry) {
        $this->dataEntryId = $indicatorDataEntry->indicator_number;
        $this->user = $user;
        $this->dataEntryUser = $dataEntryUser;
        $this->indicatorDataEntry = $indicatorDataEntry;
        $this->url = route('indicator_data_entries');
    }

    public function build() {
        return $this->subject("J&K - SDG: Submission Approved at Admin Level")
                    ->markdown('emails.final_approval_notification');
    }
}
