<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class DataSubmittedMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;
    public $user, $url;

    public function __construct($user) {
        $this->user = $user;
        $this->url = route('indicator_data_entries');

    }

    public function build() {
        return $this->subject('J&K - SDG: Acknowledgement of Data Submission - Pending Approval')
                    ->markdown('emails.data_submitted');
    }
}




