<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ApprovalRequestNotificationMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;
    
    public $user, $indicatorDataEntry, $departmentApprover, $districtApprover,$level, $admin, $url;

    // Constructor to initialize variables
    public function __construct($user, $indicatorDataEntry, $departmentApprover = false, $districtApprover = false, $admin = false, $level = null) {
        $this->user = $user;
        $this->indicatorDataEntry = $indicatorDataEntry;
        $this->departmentApprover = $departmentApprover;
        $this->districtApprover = $districtApprover;
        $this->admin = $admin;
        $this->level = $level;
        $this->url = route('indicator_data_entries');
    }

    // Build method to customize the email content
    public function build() {
        // Use $this->districtApprover to access the property
        if($this->districtApprover && $this->level == null) {
            return $this->subject("J&K - SDG: Request for Data Approval - Level 1")
                ->markdown('emails.approval_request_notification');
        } else if($this->departmentApprover && $this->level == null) {
            return $this->subject("J&K - SDG: Request for Data Approval - Level 1")
                ->markdown('emails.approval_request_notification_department');
        } else if ($this->level == 'district') {
            return $this->subject("J&K - SDG: Request for Data Approval - Level 2")
                ->markdown('emails.approval_request_notification_district_hod');
        } else if ($this->level == 'department') {
            return $this->subject("J&K - SDG: Request for Data Approval - Level 2")
                ->markdown('emails.approval_request_notification_department_hod');
        } else if ($this->level == 'HOD'){
            return $this->subject("J&K - SDG: Request for Data Approval - Level 3")
                ->markdown('emails.approval_request_notification_to_admin');
        }
    }
}



