<?php

namespace App\Listeners;

use App\Events\JobCompletedEvent;
use App\Notifications\JobCompletedNotification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Notification;

class SendJobCompletedNotification implements ShouldQueue
{
    public function handle(JobCompletedEvent $event)
    {
        $usersToNotify = ['suhel.khan@velsof.com'];
        foreach ($usersToNotify as $email) {
            Notification::route('mail', $email)->notify(new JobCompletedNotification($event->jobName, $event->numberOfIndicatorsUpdated));
        }
    }
}
