<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification;
use App\Notifications\JobFailedNotification;
use App\Events\JobCompletedEvent;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;

class ProcessEntriesJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $entries;
    protected $batchId; // Add this line

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($entries, $batchId) // Modify this line
    {
        $this->entries = $entries;
        $this->batchId = $batchId; // Add this line
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            Log::info("Starting job for batch: {$this->batchId}");
            foreach ($this->entries as $entry) {
                $indicatorId = $entry->indicator_id;
                $districtId = $entry->district_id;
                $reportingYearId = $entry->reporting_year_id;
                $goal_id = $entry->goal_id;

                if ($entry->is_positive_indicator == 'Positive') {
                    DB::statement("CALL calculateNormalizedValuePositiveIndicator('$indicatorId', '$districtId', '$reportingYearId')");
                } else {
                    DB::statement("CALL calculateNormalizedValueNegativeIndicator('$indicatorId', '$districtId', '$reportingYearId')");
                }
                DB::statement("CALL calculateDistrictGoalScore('$goal_id', '$districtId', '$reportingYearId')");
                DB::statement("CALL calculateDistrictScore('$districtId', '$reportingYearId')");
                DB::statement("CALL setDistrictsRanks('$reportingYearId')");
            }
            Cache::increment($this->batchId . '_completed');

            // Check if all chunks are processed
            $totalChunks = Cache::get($this->batchId . '_total');
            $completedChunks = Cache::get($this->batchId . '_completed');

            Log::info("Chunk completed for batch: {$this->batchId}. Completed Chunks: {$completedChunks}/{$totalChunks}");

            if ($totalChunks == $completedChunks) {
                // All chunks have been processed, send notification
                NotifyCompletionJob::dispatch($this->batchId, $totalChunks);
            }
        } catch (\Throwable $exception) {
            Log::error("Error in job for batch: {$this->batchId}. Exception: {$exception->getMessage()}");
            throw new \Exception($exception);
        }
    }

    /**
     * The job failed to process.
     *
     * @param  \Exception  $exception
     * @return void
     */
    public function failed(\Throwable $exception)
    {
        // Log the job failure details
        Log::error("Job failed: {$exception->getMessage()}");

        try {
            // Send failure notification
            Notification::route('mail', 'suhel.khan@velsof.com') // Adjust as needed
                ->notify(new JobFailedNotification($exception));
        } catch (\Exception $e) {
            // Log any exceptions thrown during the notification process
            Log::error("Failed to send job failure notification: {$e->getMessage()}");
        }
    }
}
