<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateIndicatorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            // 'indicator_type' => 'required|string',
            // 'indicator_number'=> 'required|min:3|max:30',
            // 'indicator_name' => 'required|string|min:3|max:500',
            // 'goal'=> 'required|exists:goals,id',
            'target'=> 'required|exists:targets,target_id',
            // 'department' => $this->indicator_type == 'utif' ? ['required', 'exists:departments,id'] : [''],
            // 'unit'=> 'required|string',
            // 'baseline_year'=> 'required',
            'indicator_value' => $this->unit == 'percentage' ? ['required', 'numeric', 'min:0' ,'max:100'] : ['required', 'numeric'],
            'target_value' => $this->unit == 'percentage' ? ['required', 'numeric', 'min:0' ,'max:100'] : ['required', 'numeric'],
            // 'marker'=> 'required|string',
            'value_type' => 'required_if:unit,absolute',
            // 'max_value'=> 'required|integer|gt:-1|lt:101',
            // 'min_value'=> 'required|integer|gt:-1|lt:101',
        ];
    }

    public function messages()
    {
        return [
            // 'indicator_type.required' => 'Please select an indicator type',
            // 'indicator_type.string' => 'Indicator type must be a string',
            // 'indicator_number.required' => 'Please enter an indicator number',
            // 'indicator_number.min' => 'Indicator number must be at least 3 characters',
            // 'indicator_number.max' => 'Indicator number must be at most 30 characters',
            // 'indicator_name.required' => 'Please enter an indicator name',
            // 'indicator_name.string' => 'Indicator name must be a string',
            // 'indicator_name.min' => 'Indicator name must be at least 3 characters',
            // 'indicator_name.max' => 'Indicator name must be at most 500 characters',
            // 'goal.required' => 'Please select a goal',
            // 'goal.exists' => 'Selected goal does not exist',
            'target.required' => 'Please select a target',
            'target.exists' => 'Selected target does not exist',
            // 'department.required' => 'Please select a department',
            // 'department.exists' => 'Selected department does not exist',
            // 'unit.required' => 'Please enter a unit',
            // 'unit.string' => 'Unit must be a string',
            // 'baseline_year.required' => 'Please enter a baseline year',
            'indicator_value.required' => 'Please enter a baseline value',
            'indicator_value.numeric' => 'Baseline value must be a valid numeric value',
            'indicator_value.min' => 'For percentage unit, baseline value must be between 0 and 100',
            'indicator_value.max' => 'For percentage unit, baseline value must be between 0 and 100',
            'target_value.required' => 'Please enter a target value',
            'target_value.numeric' => 'Target value must be a valid numeric value',
            'target_value.min' => 'For percentage unit, target value must be between 0 and 100',
            'target_value.max' => 'For percentage unit, target value must be between 0 and 100',
            // 'marker.required' => 'Please enter a marker',
            // 'marker.string' => 'Marker must be a string',
            'value_type.required' => 'Please select a value type',
            'value_type.string' => 'Value type must be a string',
            // 'max_value.required' => 'Please enter a maximum value',
            // 'max_value.integer' => 'Maximum value must be an integer',
            // 'max_value.gt' => 'Maximum value must be greater or equal to 0',
            // 'max_value.lt' => 'Maximum value must be less or equal to 100',
            // 'min_value.required' => 'Please enter a minimum value',
            // 'min_value.integer' => 'Minimum value must be an integer',
            // 'min_value.gt' => 'Minimum value must be greater or equal to 0',
            // 'min_value.lt' => 'Minimum value must be less or equal to maximum value',
        ];
    }
}
