<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DistrictRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'district_name' => 'required|string|min:2|max:100|unique:districts,district_name,',
            'district_code' => 'required|string|min:2|max:10|unique:districts,district_code,',
            'division' => 'required|string',
        ];
    }
}
