<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class preventParameterPollution
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        $inputs = $request->all();

        foreach ($inputs as $key => $value) {
            if (is_array($value)) {
                // If a parameter is an array, it means there are multiple parameters with the same name.
                // You can handle this in whatever way is appropriate for your application.
                // In this example, we're just taking the last parameter.
                $request->merge([$key => end($value)]);
            }
        }

        return $next($request);
    }
}
