<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class FrameOptions
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        $response->headers->set('Content-Security-Policy', "frame-ancestors 'none';");

        // Add X-Frame-Options header
        $response->headers->set('X-Frame-Options', 'DENY');

        return $response;
    }
}
