<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class FilterInputs
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        //accessing each input
        foreach ($request->input() as $key => $value) {
            //putting the orignal value in a variable
            $new_value = $value;
            //checking only the string values, skipping array values (such as multiple selects) because these inputs cannot be affected by end user
            if (!is_array($value)) {
                //removing the tags if applied in the input variable
                $new_value = strip_tags($value);
                //decoding the html entities to their code representation from symbolic representation
                $new_value = html_entity_decode($new_value);
            }
            //putting back the new filtered input
            $request->merge(array($key => $new_value));
        }
        return $next($request);
    }
}
