<?php
// BOC
// Task #156544 The Comparison on SDG India Index section should display a detailed comparison of SDG scores with other states.
// This controller is used to load data on the admin dashboard for the input of the comparison data. This controller controller contains getcomparisionData function which is called using ajax.
// @author Almaaz Ahmed
// @date 20-12-2024
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Helpers\PublicPageHelper;
use Illuminate\Database\QueryException;
use App\Models\GoalComparisionWithIndia;
use Illuminate\Support\Facades\Log;
use App\Models\State;
use App\Models\ReportingYear;
use App\Helpers\CommonHelper;
use Illuminate\Support\Facades\DB;

class GoalComparisionWithIndiaController extends Controller
{
    public function getcomparisionData(Request $request)
    {
        $goal = $request->input('goal');
        $year = $request->input('year');
        $goalId = str_replace('mc-', '', $goal); // Extract the goal number
        if ($goalId === "all") {
            $goalId = null; // Handle the case when "all" is selected
        }

        try {
            // Fetch comparison data for the given goal and year
            $data = GoalComparisionWithIndia::query()
            ->leftJoin('states as best_state', 'goal_comparision_with_india.best_performer_state', '=', 'best_state.state_id')
            ->leftJoin('states as ut', 'goal_comparision_with_india.best_performer_ut', '=', 'ut.state_id')
            ->where('goal_comparision_with_india.goal_id', $goalId)
            ->where('goal_comparision_with_india.reporting_year_id', $year)
            ->select(
                'goal_comparision_with_india.goal_id',
                'goal_comparision_with_india.india_score',
                'goal_comparision_with_india.best_performer_state',
                'goal_comparision_with_india.best_performer_state_score',
                'goal_comparision_with_india.jammu_and_kashmir_score',
                'goal_comparision_with_india.jammu_and_kashmir_category',
                'goal_comparision_with_india.best_performer_ut',
                'goal_comparision_with_india.best_performer_ut_score',
                'best_state.state_name as best_performer_state_name',
                'ut.state_name as best_performer_ut_name'
            )
            ->get();
            // $query = $data->toSql();
            // $query_With_Bindings = $data->getBindings();  
        } catch (QueryException $e) {
            // Log the exception with details
            $logData['file'] = __FILE__;
            $logData['method'] = __FUNCTION__;
            $logData['query'] = $e->getSql();
            $logData['exception'] = $e->getMessage();
            // Log exception to file with file name and method information
            CommonHelper::dataActionLogger($logData, 'exception');

            return response()->json([
                'categories' => "No data",
                'values' => [],
                'indiaMap' => []
            ]);
        }

        // Check if data is available and prepare it for Highcharts
        if (!empty($data) && $data->isNotEmpty()) {
            $firstRecord = $data->first();
            $best_performer_ut = $firstRecord->best_performer_ut_name ?? null; // Handle null safely

            // Define categories for Highcharts
            $categories = [
                'India',
                $firstRecord->best_performer_state_name ? $firstRecord->best_performer_state_name . " (Best Performing State)" : 'Unknown',
                'Jammu and Kashmir',
                $best_performer_ut ? $best_performer_ut . " (Best Performing UT)" : 'Unknown',
            ];          

            // Define values for Highcharts with color coding
            $values = [
                ['y' => $firstRecord->india_score, 'color' => PublicPageHelper::determineColor($firstRecord->india_score)],
                ['y' => $firstRecord->best_performer_state_score, 'color' => PublicPageHelper::determineColor($firstRecord->best_performer_state_score)],
                ['y' => $firstRecord->jammu_and_kashmir_score ?? 0, 'color' => PublicPageHelper::determineColor($firstRecord->jammu_and_kashmir_score ?? 0)],
                ['y' => $firstRecord->best_performer_ut_score ?? 0, 'color' => PublicPageHelper::determineColor($firstRecord->best_performer_ut_score ?? 0)]
            ];

            // Remove the best-performing state from the "India" array
            $bestPerformerStateName = $firstRecord->best_performer_state_name;

            // Determine Jammu and Kashmir's category based on score
            $jammu_and_kashmir_category = $firstRecord->jammu_and_kashmir_category ?? 'Information Unavailable';
            $indiaMap[$jammu_and_kashmir_category][] = ["Jammu and Kashmir"];

            // Determine best performer state's category based on score
            if ($firstRecord->best_performer_state_score == 100) {
                $bestPerformerCategory = "Achiever";
            } elseif ($firstRecord->best_performer_state_score >= 65) {
                $bestPerformerCategory = "Front Runner";
            } elseif ($firstRecord->best_performer_state_score >= 50) {
                $bestPerformerCategory = "Performer";
            } elseif ($firstRecord->best_performer_state_score >= 0) {
                $bestPerformerCategory = "Aspirant";
            } else {
                $bestPerformerCategory = "Information Unavailable";
            }

            // Add best performer state to the respective category
            $indiaMap[$bestPerformerCategory][] = [$bestPerformerStateName];

            return response()->json([
                'categories' => $categories,
                'values' => $values,
            ]);
        } else {
            // If no data is available
            return response()->json([
                'categories' => "No data",
                'values' => [],
            ]);
        }
    }

    // This function is used to get the comparison data for the public page. 
    public function getPublicPageComparisonData(Request $request)
    {
        // raw query
        // SELECT 
        //     gci.reporting_year AS financial_year,
        //     gci.india_score,
        //     gci.jammu_and_kashmir_score,
        //     gci.jammu_and_kashmir_category,
        //     gci.best_performer_state_score,
        //     s.state_name AS best_performer_state,
        //     gci.best_performer_ut_score,
        //     ut.state_name AS best_performer_ut
        // FROM 
        //     goal_comparision_with_india gci
        // LEFT JOIN 
        //     states AS s ON gci.best_performer_state = s.state_id
        // LEFT JOIN 
        //     states AS ut ON gci.best_performer_ut = ut.state_id
        // WHERE 
        //     gci.goal_id = :goalId
        // ORDER BY 
        //     gci.reporting_year DESC
        // LIMIT 5;


        try {
            $data = GoalComparisionWithIndia::query()
                ->leftJoin('states as s', 'goal_comparision_with_india.best_performer_state', '=', 's.state_id')
                ->leftJoin('states as ut', 'goal_comparision_with_india.best_performer_ut', '=', 'ut.state_id')
                ->whereNull('goal_comparision_with_india.goal_id')
                ->select(
                    'goal_comparision_with_india.reporting_year as financial_year',
                    'goal_comparision_with_india.india_score',
                    'goal_comparision_with_india.jammu_and_kashmir_score',
                    'goal_comparision_with_india.jammu_and_kashmir_category',
                    'goal_comparision_with_india.best_performer_state_score',
                    's.state_name as best_performer_state',
                    'goal_comparision_with_india.best_performer_ut_score',
                    'ut.state_name as best_performer_ut'
                )
                ->orderByDesc('goal_comparision_with_india.reporting_year') // Order by year descending
                ->take(5) // Fetch the last 4 rows
                ->get();

            // Task #157546 Creation of Home Page of the Dashboard.
            // Author : Almaaz Ahmed
            // Date : 17-01-2025
            // The below code is used to fill the table on the comparison page according to different goals

            // raw query
            // SELECT 
            //     gci.goal_id,
            //     g.goal_name,
            //     gci.reporting_year,
            //     gci.india_score,
            //     gci.jammu_and_kashmir_score,
            //     gci.best_performer_state_score,
            //     s.state_name as best_performer_state,
            //     gci.best_performer_ut_score,
            //     ut.state_name as best_performer_ut
            // FROM 
            //     goal_comparision_with_india gci
            // LEFT JOIN 
            //     states as s ON gci.best_performer_state = s.state_id
            // LEFT JOIN 
            //     states as ut ON gci.best_performer_ut = ut.state_id
            // JOIN 
            //     goals as g ON g.id = gci.goal_id
            // WHERE 
            //     gci.goal_id IS NOT NULL
            // ORDER BY 
            //     gci.reporting_year DESC, 
            //     gci.goal_id
            // Fetch data for the latest two years dynamically
        $goalWisetabledata = DB::table('goal_comparision_with_india as gci')
            ->leftJoin('states as s', 'gci.best_performer_state', '=', 's.state_id')
            ->leftJoin('states as ut', 'gci.best_performer_ut', '=', 'ut.state_id')
            ->join('goals as g', 'g.id', '=', 'gci.goal_id')
            ->whereNotNull('gci.goal_id')
            ->select(
                'gci.goal_id',
                'g.goal_name',
                'gci.reporting_year',
                'gci.india_score',
                'gci.jammu_and_kashmir_score',
                'gci.best_performer_state_score',
                's.state_name as best_performer_state',
                'gci.best_performer_ut_score',
                'ut.state_name as best_performer_ut'
            )
            ->orderBy('gci.reporting_year', 'desc') // Order by reporting_year descending
            ->orderBy('gci.goal_id') // Order by goal_id
            ->get();

            // Initialize variables
            $tabledata = [];
            $dataByGoalId = [];

            // Group data by goal_id and keep only the latest two years for each goal
            foreach ($goalWisetabledata as $row) {
                if (!isset($dataByGoalId[$row->goal_id])) {
                    $dataByGoalId[$row->goal_id] = [];
                }

                // Store only the latest two years for each goal
                if (count($dataByGoalId[$row->goal_id]) < 2) {
                    $dataByGoalId[$row->goal_id][$row->reporting_year] = $row;
                }
            }

            // Prepare tabledata with conditional logic
            foreach ($dataByGoalId as $goal_id => $years) {
                // Get the latest two years' data
                $years = array_values($years); // Reindex the array
                $currentYear = $years[0] ?? null;
                $previousYear = $years[1] ?? null;

                if ($currentYear && $previousYear) {
                    // Both years are present, compare scores
                    $indiaTrend = $currentYear->india_score <=> $previousYear->india_score;
                    $jkTrend = $currentYear->jammu_and_kashmir_score <=> $previousYear->jammu_and_kashmir_score;

                    $tabledata[] = [
                        'goal_id' => $goal_id,
                        'goal_name' => $currentYear->goal_name,
                        'india_score' => $currentYear->india_score,
                        'india_score_trend' => $indiaTrend > 0 ? 'up' : ($indiaTrend < 0 ? 'down' : 'straight'),
                        'jammu_and_kashmir_score' => $currentYear->jammu_and_kashmir_score,
                        'jk_score_trend' => $jkTrend > 0 ? 'up' : ($jkTrend < 0 ? 'down' : 'straight'),
                        'best_performer_state' => $currentYear->best_performer_state,
                        'best_performer_state_score' => $currentYear->best_performer_state_score,
                        'best_performer_ut' => $currentYear->best_performer_ut,
                        'best_performer_ut_score' => $currentYear->best_performer_ut_score,
                    ];
                } elseif ($currentYear) {
                    // Only current year's data is available
                    $tabledata[] = [
                        'goal_id' => $goal_id,
                        'goal_name' => $currentYear->goal_name,
                        'india_score' => $currentYear->india_score,
                        'india_score_trend' => null, // No trend
                        'jammu_and_kashmir_score' => $currentYear->jammu_and_kashmir_score,
                        'jk_score_trend' => null, // No trend
                        'best_performer_state' => $currentYear->best_performer_state,
                        'best_performer_state_score' => $currentYear->best_performer_state_score,
                        'best_performer_ut' => $currentYear->best_performer_ut,
                        'best_performer_ut_score' => $currentYear->best_performer_ut_score,
                    ];
                }
            }
          
        } catch (QueryException $e) {
            $logData['file'] = __FILE__;
            $logData['method'] = __FUNCTION__;
            $logData['query'] = $e->getSql();
            $logData['exception'] = $e->getMessage();
            // Log exception to file with file name and method information
            CommonHelper::dataActionLogger($logData, 'exception');
            $data = [];
        }

        return response()->json([
            'data' => $data,
            'tabledata' => $tabledata
        ]);
    }
}
