<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class IndicatorExport implements FromCollection, WithHeadings
{
    protected $indicators;

    public function __construct($indicators)
    {
        $this->indicators = $indicators;
    }
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return $this->indicators;
    }

    public function headings(): array
    {
        return [
            'Indicator ID',
            'Indicator Number',
            'Indicator Name',
            'Indicator Goal',
            'Indicator Target',
            'Is Indicator DIF',
            'Is Indicator UTIF',
            'Indicator Unit',
            'Indicator Marker',
            'Indicator Status',
            'Baseline Year',
            'Date Added',
            'Date Updated'
        ];
    }
}
