<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class IndicatorDataEntries implements FromCollection, WithHeadings
{
    protected $indicators;

    public function __construct($indicators)
    {
        $this->indicators = $indicators;
    }
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return $this->indicators;
    }

    public function headings(): array
    {
        return [
            'Indicator Data Entries ID',
            'Indicator ID',
            'Indicator Number',
            'Indicator Name',   
            'Unit',
            'Value Type',
            'Baseline Value',
            'Baseline Year',
            'Target 2030',
            'Data Value (Current year)',
            'Status',
        ];
    }
}
