<?php

namespace App\Exports;
use App\Models\District;
use Maatwebsite\Excel\Concerns\WithHeadings;

use Maatwebsite\Excel\Concerns\FromCollection;

class DistrictExport implements FromCollection, WithHeadings
{
    protected $districts;

    public function __construct($districts)
    {
        $this->districts = $districts;
    }
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return $this->districts;
    }

    public function headings(): array
    {
        return [
            'ID',
            'District Name',
            'District Code',
            'Region'
        ];
    }
}
